<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ClassificationCtrl extends MY_Controller {

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
  }
  public function _remap($met,$parametros = array()){

  $method = $_SERVER['REQUEST_METHOD'];

 switch ($met)  
 { case 'Buscar1':
     $this->Buscar1($parametros); 
     break;
   case 'Buscar2': 
     $this->Buscar2($parametros);   
   break;
   case 'Buscar3': 
     $this->Buscar3($parametros); 
   break; 
   case 'Buscar4': 
    $this->Buscar4($parametros);
   break; 
   case 'Buscar5': 
    $this->Buscar5($parametros);
   break; 
   case "MetaData":
    $this->MetaData($parametros);
   break;

 }
 if($met ==="index"){

  switch ($method)  
  { case 'PUT':
      $this->Edit(); 
    break;
    case 'POST': 
      $this->Add();
    break;
    case 'GET': 
      $this->Search($parametros);
 break;
    case 'HEAD': 
      // echo json_encode( $method );
    break; 
    case 'DELETE': 
      $this->Delete($parametros); 
    break; 
    case 'OPTIONS': 
     // echo json_encode( $method );
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
}


 }
private function Add(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

    $Classificationes= $this->ClassificationModels->Add($Datos);

  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes);
}
     
private function Edit(){
  $Datos = $this->input->raw_input_stream;
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }
  $Classificationes= $this->ClassificationModels->Edit($Datos);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes);
    
}

private function Delete($ID ){
  $Classificationes= $this->ClassificationModels->Delete($ID[0]);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes);
}

// aqui viene los metodos de buscar



private function Search($Arr =array() ){
  $Classificationes =array();
  switch (count($Arr)) 
  { case 0:
    $Classificationes= $this->ClassificationModels->getClassification();
    break;
    case 1: 
      $Classificationes = $this->ClassificationModels->getClassification($Arr[0]);
    break;
    case 2: 
      $Classificationes = $this->ClassificationModels->getClassificationLimite($Arr[0],$Arr[1]);
    break; 
    case 4: 
      $Classificationes = $this->ClassificationModels->getClassificationLimiteOrden($Arr[0],$Arr[1],$Arr[2],$Arr[3]);
    break; 
    case 5: 
      $Classificationes = $this->ClassificationModels->getClassificationLimiteOrdenColumnas($Arr[0],$Arr[1],$Arr[2],$Arr[3],urldecode($Arr[4]));
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
}

private function Buscar1 ($Arr = array()){
  $Classificationes =array();
  switch (count($Arr)) 
  {
    case 1: 
      $Classificationes = $this->ClassificationModels->getClassificationFiltro(urldecode($Arr[0]));
    break;
    case 3: 
      $Classificationes = $this->ClassificationModels->getClassificationFiltroLimite(urldecode($Arr[0]),$Arr[1],$Arr[2]);
    break; 
    case 5: 
      $Classificationes = $this->ClassificationModels->getClassificationFiltroLimiteOrden(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4]);
   break; 
   case 6: 
    $Classificationes = $this->ClassificationModels->getClassificationFiltroLimiteOrdenColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4],urldecode($Arr[5]));
    break; 
   default: 
   echo json_encode( $Arr );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
  
}
private function Buscar2 ($Arr =array()){
  $Classificationes =array();
  $Classificationes = $this->ClassificationModels->getClassificationFiltroColumnas(urldecode($Arr[0]),urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
}

private function Buscar3 ($Arr =array()){
  $Classificationes =array();
    $Classificationes= $this->ClassificationModels->  getClassificationIdColum($Arr[0],urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
}
private function Buscar4 ($Arr = array()){
  $Classificationes =array();
    $Classificationes= $this->ClassificationModels->getClassificationLimiteColum($Arr[0],$Arr[1],urldecode($Arr[2]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
}
private function Buscar5 ($Arr =  array()){
  $Classificationes =array();
  $Classificationes = $this->ClassificationModels->getClassificationFiltroLimitesColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],urldecode($Arr[3]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 

}


private function MetaData(){
  $Classificationes =array();
  $Classificationes = $this->ClassificationModels->MetaData();
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Classificationes); 
}

    protected function middleware()
    {
      return ['Sesion','Permisos'];
    }

	
}