<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class CylinderCtrl extends MY_Controller {

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
  }
  public function _remap($met,$parametros = array()){

  $method = $_SERVER['REQUEST_METHOD'];

 switch ($met)  
 { case 'Buscar1':
     $this->Buscar1($parametros); 
     break;
   case 'Buscar2': 
     $this->Buscar2($parametros);   
   break;
   case 'Buscar3': 
     $this->Buscar3($parametros); 
   break; 
   case 'Buscar4': 
    $this->Buscar4($parametros);
   break; 
   case 'Buscar5': 
    $this->Buscar5($parametros);
   break; 
   case "MetaData":
    $this->MetaData($parametros);
   break;

 }
 if($met ==="index"){

  switch ($method)  
  { case 'PUT':
      $this->Edit(); 
    break;
    case 'POST': 
      $this->Add();
    break;
    case 'GET': 
      $this->Search($parametros);
 break;
    case 'HEAD': 
      // echo json_encode( $method );
    break; 
    case 'DELETE': 
      $this->Delete($parametros); 
    break; 
    case 'OPTIONS': 
     // echo json_encode( $method );
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
}


 }
private function Add(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

    $Cylinderes= $this->CylinderModels->Add($Datos);

  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes);
}
     
private function Edit(){
  $Datos = $this->input->raw_input_stream;
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }
  $Cylinderes= $this->CylinderModels->Edit($Datos);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes);
    
}

private function Delete($ID ){
  $Cylinderes= $this->CylinderModels->Delete($ID[0]);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes);
}

// aqui viene los metodos de buscar



private function Search($Arr =array() ){
  $Cylinderes =array();
  switch (count($Arr)) 
  { case 0:
    $Cylinderes= $this->CylinderModels->getCylinder();
    break;
    case 1: 
      $Cylinderes = $this->CylinderModels->getCylinder($Arr[0]);
    break;
    case 2: 
      $Cylinderes = $this->CylinderModels->getCylinderLimite($Arr[0],$Arr[1]);
    break; 
    case 4: 
      $Cylinderes = $this->CylinderModels->getCylinderLimiteOrden($Arr[0],$Arr[1],$Arr[2],$Arr[3]);
    break; 
    case 5: 
      $Cylinderes = $this->CylinderModels->getCylinderLimiteOrdenColumnas($Arr[0],$Arr[1],$Arr[2],$Arr[3],urldecode($Arr[4]));
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
}

private function Buscar1 ($Arr = array()){
  $Cylinderes =array();
  switch (count($Arr)) 
  {
    case 1: 
      $Cylinderes = $this->CylinderModels->getCylinderFiltro(urldecode($Arr[0]));
    break;
    case 3: 
      $Cylinderes = $this->CylinderModels->getCylinderFiltroLimite(urldecode($Arr[0]),$Arr[1],$Arr[2]);
    break; 
    case 5: 
      $Cylinderes = $this->CylinderModels->getCylinderFiltroLimiteOrden(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4]);
   break; 
   case 6: 
    $Cylinderes = $this->CylinderModels->getCylinderFiltroLimiteOrdenColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4],urldecode($Arr[5]));
    break; 
   default: 
   echo json_encode( $Arr );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
  
}
private function Buscar2 ($Arr =array()){
  $Cylinderes =array();
  $Cylinderes = $this->CylinderModels->getCylinderFiltroColumnas(urldecode($Arr[0]),urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
}

private function Buscar3 ($Arr =array()){
  $Cylinderes =array();
    $Cylinderes= $this->CylinderModels->  getCylinderIdColum($Arr[0],urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
}
private function Buscar4 ($Arr = array()){
  $Cylinderes =array();
    $Cylinderes= $this->CylinderModels->getCylinderLimiteColum($Arr[0],$Arr[1],urldecode($Arr[2]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
}
private function Buscar5 ($Arr =  array()){
  $Cylinderes =array();
  $Cylinderes = $this->CylinderModels->getCylinderFiltroLimitesColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],urldecode($Arr[3]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 

}


private function MetaData(){
  $Cylinderes =array();
  $Cylinderes = $this->CylinderModels->MetaData();
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Cylinderes); 
}

    protected function middleware()
    {
      return ['Sesion','Permisos'];
    }

	
}