<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PagoCreditoCtrl extends MY_Controller {

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
      $this->load->library('Pdf');
  }
  public function _remap($met){
  $method = $_SERVER['REQUEST_METHOD'];
   if($met ==="index"){
       if($method=='POST'){
          $this->Pagos();
       }else{
          echo json_encode( "Error" );
       }
      }
 }
 private function Pagos(){
  $Datos = $this->DatosPost();
  if($this->ValidarPost($Datos)== false){
   header('Content-type: application/json; charset=utf-8');
   echo json_encode(array("Error"=> "Faltan Datos"));
   return;
  }
  $Dinero =floatval($Datos["Total"]);
  $Ventas = $this->VentasCredito($Datos["Cod"]);
  $Medio = $Datos["MedioPago"];
  $Obs = $Datos["Obs"];
 $this->RealizarAbonos($Dinero,$Ventas,$Medio,$Obs);
 $Creditos = $this->VentasCredito($Datos["Cod"]);
 header('Content-type: application/json; charset=utf-8');
 echo json_encode($Creditos);
}
private function RealizarAbonos($Dinero,$Ventas,$Medio,$Obs){
  $DineroRestante = $Dinero;
  foreach ($Ventas as $Fila){
    $DineroRestante=  $this->ProcesarPago($Dinero,$Fila,$Medio,$Obs);
    if ($DineroRestante==-1) break;
  }
} 
 private function DatosPost(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

  return $Datos; 
 }  
 private function ValidarPost($Datos){
  $validado = true;
  if (!isset($Datos["Cod"])){
    $validado = false;
  }
  if (!isset($Datos["Total"])){
    $validado = false;
  }
  if (!isset($Datos["MedioPago"])){
    $validado = false;
  }
  if (!isset($Datos["Obs"])){
    $validado = false;
  }
  return  $validado;
 }
 private function VentasCredito($Cliente){
  return  $this->ReporVentasCreditoModels->getReporVentasCreditoFiltro("sCodCliente^".$Cliente."|Status^En Proceso");
 }


//en esta funcion procesamos el pago de una venta segun el dinero disponible

private function MedioDePago($Medio){
  $NumeroDeCampo = 9;
  switch ($Medio)  
  { case 'Efectivo': 
    $NumeroDeCampo = 9;
    break;
    case 'Debito': 
        $NumeroDeCampo = 10;
    break; 
    case 'Credito': 
        $NumeroDeCampo = 11;
   break; 
   default: 
   
   break; 
  }
  return $NumeroDeCampo;
}
private function ProcesarPago($Dinero = -1, $Venta, $Tipo, $Obs){
if($Dinero == -1) return $Dinero;
$Codigo = utf8_encode("Código");
$Codigo = $Venta->$Codigo;
 $Deuda = $Venta->MontoTotal - (floatval($Venta->Efectivo) +  floatval($Venta->Debito) + floatval($Venta->Credito))  ;

  $MontoActualizar = 0;
  $TotalPagado = 0;
  $NumeroDeCampo = $this->MedioDePago($Tipo);
  switch ($Tipo)  
  { case 'Efectivo': 
    $MontoActualizar = floatval($Venta->Efectivo);
    break;
    case 'Debito': 
        $MontoActualizar = floatval($Venta->Debito);
    break; 
    case 'Credito': 
        $MontoActualizar = floatval($Venta->Credito);
   break; 
   default: 
   
   break; 
  }
  // el TotalPagado  depende de si el dinero me alcanza o no para pagar la deuda
  $TotalPagado  =  $Deuda < $Dinero ? $Deuda : $Dinero;
  // MontoActualizar es la suma del monto existente mas el nuevo monto 
  $MontoActualizar =  $Deuda < $Dinero ? $MontoActualizar+ $Deuda:  $MontoActualizar+ $Dinero;
  
   $num = 0;
    $obj = new stdClass();
    $obj->$num = $Codigo;
    $obj->$NumeroDeCampo =  $MontoActualizar;
    $num = 8;
    $obj->$num = $Deuda <= $Dinero ?"Procesado":'En Proceso';
    // actualizamos el registro de las ventas
     $this->VentasModels->Edit($obj);
     $Token = obtnerToken();
      $Autho = "";
    if($Token != FALSE){
      $Autho =str_replace('Bearer ','', $Token);
    }
    if( $Autho !=""){
      $Autho =str_replace('Bearer ','', $Autho);
      $Token = ValidarToken($Autho);
    }
     if(isset($this->session)){
       $IDuser =  $Token == FALSE ? $this->session->userdata("User") :  $Token;
 }else{
   $IDuser =  $Token == FALSE ?null :  $Token;
 }
     
 
     $Venta = $this->ReporVentasModels->getReporVentas($Codigo);
    // Creamos los registros de detalle de la operacinon
    $objCredito = new stdClass();
    $objCredito->Venta =  $Codigo;
    $objCredito->Observacion = $Obs;
    $objCredito->Usuario =$IDuser;
    $objCredito->Tienda =$Venta[0]->CodTienda;
    $objCredito->Abono = $TotalPagado;
    $objCredito->Medio = $Tipo;
      $this->CreditosModels->Add($objCredito);
  if ($Dinero <  $Deuda){

    return -1;
  }else{
    return $Dinero - $Deuda;
  }

}



   protected function middleware()
    {
      return ['Sesion'];
    }

	
}