<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class RaftCtrl extends MY_Controller {

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
  }
  public function _remap($met,$parametros = array()){

  $method = $_SERVER['REQUEST_METHOD'];

 switch ($met)  
 { case 'Buscar1':
     $this->Buscar1($parametros); 
     break;
   case 'Buscar2': 
     $this->Buscar2($parametros);   
   break;
   case 'Buscar3': 
     $this->Buscar3($parametros); 
   break; 
   case 'Buscar4': 
    $this->Buscar4($parametros);
   break; 
   case 'Buscar5': 
    $this->Buscar5($parametros);
   break; 
   case "MetaData":
    $this->MetaData($parametros);
   break;

 }
 if($met ==="index"){

  switch ($method)  
  { case 'PUT':
      $this->Edit(); 
    break;
    case 'POST': 
      $this->Add();
    break;
    case 'GET': 
      $this->Search($parametros);
 break;
    case 'HEAD': 
      // echo json_encode( $method );
    break; 
    case 'DELETE': 
      $this->Delete($parametros); 
    break; 
    case 'OPTIONS': 
     // echo json_encode( $method );
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
}


 }
private function Add(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

    $Raftes= $this->RaftModels->Add($Datos);

  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes);
}
     
private function Edit(){
  $Datos = $this->input->raw_input_stream;
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }
  $Raftes= $this->RaftModels->Edit($Datos);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes);
    
}

private function Delete($ID ){
  $Raftes= $this->RaftModels->Delete($ID[0]);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes);
}

// aqui viene los metodos de buscar



private function Search($Arr =array() ){
  $Raftes =array();
  switch (count($Arr)) 
  { case 0:
    $Raftes= $this->RaftModels->getRaft();
    break;
    case 1: 
      $Raftes = $this->RaftModels->getRaft($Arr[0]);
    break;
    case 2: 
      $Raftes = $this->RaftModels->getRaftLimite($Arr[0],$Arr[1]);
    break; 
    case 4: 
      $Raftes = $this->RaftModels->getRaftLimiteOrden($Arr[0],$Arr[1],$Arr[2],$Arr[3]);
    break; 
    case 5: 
      $Raftes = $this->RaftModels->getRaftLimiteOrdenColumnas($Arr[0],$Arr[1],$Arr[2],$Arr[3],urldecode($Arr[4]));
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
}

private function Buscar1 ($Arr = array()){
  $Raftes =array();
  switch (count($Arr)) 
  {
    case 1: 
      $Raftes = $this->RaftModels->getRaftFiltro(urldecode($Arr[0]));
    break;
    case 3: 
      $Raftes = $this->RaftModels->getRaftFiltroLimite(urldecode($Arr[0]),$Arr[1],$Arr[2]);
    break; 
    case 5: 
      $Raftes = $this->RaftModels->getRaftFiltroLimiteOrden(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4]);
   break; 
   case 6: 
    $Raftes = $this->RaftModels->getRaftFiltroLimiteOrdenColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4],urldecode($Arr[5]));
    break; 
   default: 
   echo json_encode( $Arr );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
  
}
private function Buscar2 ($Arr =array()){
  $Raftes =array();
  $Raftes = $this->RaftModels->getRaftFiltroColumnas(urldecode($Arr[0]),urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
}

private function Buscar3 ($Arr =array()){
  $Raftes =array();
    $Raftes= $this->RaftModels->  getRaftIdColum($Arr[0],urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
}
private function Buscar4 ($Arr = array()){
  $Raftes =array();
    $Raftes= $this->RaftModels->getRaftLimiteColum($Arr[0],$Arr[1],urldecode($Arr[2]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
}
private function Buscar5 ($Arr =  array()){
  $Raftes =array();
  $Raftes = $this->RaftModels->getRaftFiltroLimitesColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],urldecode($Arr[3]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 

}


private function MetaData(){
  $Raftes =array();
  $Raftes = $this->RaftModels->MetaData();
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Raftes); 
}

    protected function middleware()
    {
      return ['Sesion','Permisos'];
    }

	
}