<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ArticlesModels extends CI_Model
{
    /*
    `SELECT  tienda.NombreT AS Tienda, clasificacion.Nombre AS Area,producto.CodigoP AS Codigo, producto.Nombre AS Producto ,producto.Marca AS Marca, producto.Modelo AS Modelo,movimientop.Existencia AS Stock, proveedor.Nombres AS Proveedor, proveedor.Telefono AS Telefono,  movimientop.charge as Encargo,  detallemov.Costo As Costo, detallemov.Cantidad As Ultima_Compra, detallemov.CodigoD AS Detalle,  movimientop.StopMinimo AS Minimo, movimientop.StopMax AS Max FROM tienda 
    LEFT JOIN movimientop ON movimientop.CodigoT = tienda.Codigo
    LEFT JOIN producto ON movimientop.CodigoP = producto.CodigoP 
    LEFT JOIN clasificacion On clasificacion.ID = producto.Clasificacion 
    LEFT JOIN detallemov ON movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )
    LEFT JOIN proveedor ON detallemov.CodigoProve  = proveedor.CodigoProve  
    WHERE  ( producto.Status = 'Activo' )  ORDER BY movimientop.Existencia ASC`
    */
    private $Tabla = "tienda";
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposTablas = ["movimientop.CodigoM","producto.CodigoP","producto.Nombre","tienda.NombreT","producto.Modelo","producto.Marca","producto.Descripcion","movimientop.CostoD","movimientop.Existencia","detallemov.Fecha","proveedor.Nombres","proveedor.Telefono","movimientop.charge", "detallemov.Costo", "detallemov.Cantidad", "detallemov.CodigoD", "movimientop.StopMinimo", "movimientop.StopMax","tienda.Codigo","producto.Unidades","proveedor.CodigoProve","clasificacion.Nombre","detallemov.CodigoAux", "movimientop.CostoM","movimientop.CantidadM","movimientop.iva","movimientop.ILA"];
    private function InitJoin(){
        $this->db->join("movimientop"," movimientop.CodigoT = tienda.Codigo","LEFT",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("clasificacion","clasificacion.ID = producto.Clasificacion","LEFT",false);
        $this->db->join("detallemov","movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM AND detallemov.Status =  'Entrada' )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )","LEFT",false);
        $this->db->join("proveedor","detallemov.CodigoProve  = proveedor.CodigoProve","LEFT",false);
        $this->db->where('producto.Status',$this->db->escape("Activo"),false);
        $this->db->where('movimientop.Status',$this->db->escape("Activo"),false);
       }
     
       private function InitJoinCodigo(){
        $this->db->join("movimientop"," movimientop.CodigoT = tienda.Codigo","LEFT",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("clasificacion","clasificacion.ID = producto.Clasificacion","LEFT",false);
        $this->db->join("detallemov","movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM AND detallemov.Status =  'Entrada' )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )","LEFT",false);
        $this->db->join("proveedor","detallemov.CodigoProve  = proveedor.CodigoProve","LEFT",false);
        $this->db->where('producto.Status',$this->db->escape("Auxiliar"),false);
        
       }
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }
 



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
               
              $arr1[$i] =  $Array2;
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getArticles($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where($this->Tabla.'.CodigoM',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getCodigo($id=NULL,$CodTienda = '5')
    {
       
       if ($id === NULL){
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where('tienda.Codigo',$this->db->escape($CodTienda),false);
           $this->db->where('producto'.'.CodigoP',$this->db->escape("$id"),false);
           $Busqueda =  $this->db->get($this->Tabla)->result();
         if( count($Busqueda) > 0 ){
             return $Busqueda;
         }else{
            $ID2= $this->ValidarCdProducto($id);
            $this->db->select($this->Columnas(),false);
            $this->InitJoin();
            $this->db->where('tienda.Codigo',$this->db->escape($CodTienda),false);
              $this->db->where('producto'.'.CodigoP',$this->db->escape("$ID2"),false);
              $Busqueda = $this->db->get($this->Tabla)->result();
              if(count($Busqueda) > 0){
                $Busqueda[0]->Producto = $id;
                $Busqueda[0]->CodigoAux = $id;
                
              }
              return  $Busqueda;
              
         }
       }
       
    }
    public function getArticlesLimite($Canti,$Desde){
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getArticlesLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getArticlesLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){

        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getArticlesIdColum($id,$Columnas){
       
        $this->db->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getArticlesLimiteColum($Canti,$Desde,$Columnas){
        $this->db->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getArticlesFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
      
        $this->db->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getArticlesFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->select($this->Columnas(),false);
     return   $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getArticlesFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getArticlesFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }

        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getArticlesFiltroColumnas($Filtros,$Columnas){
       
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getArticlesFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
      // chanchilo
    
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $array_num = count($arrayconsulta);
     if(  $arrayconsulta[0][0] ==='tienda.Codigo' ){
        
        for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
              $Bus=  $this->getCodigo($arrayconsulta[$i][1], str_replace("'",'',$arrayconsulta[0][1]));
              if(count($Bus) > 0){
                return  $Bus;
              }
            
             
            }
         }
     }
  

      $this->InitJoin();

        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave){
        
$ArrayArticles["producto.Unidades"]= "Unidades";
$ArrayArticles["tienda.NombreT"]= "Tienda";
$ArrayArticles["tienda.Codigo"]= "CodTienda";
$ArrayArticles["clasificacion.Nombre"]=  utf8_encode('Área');
$ArrayArticles["producto.CodigoP"]= utf8_encode("Producto");
$ArrayArticles["movimientop.CodigoM"]= utf8_encode("Código");
$ArrayArticles["producto.Nombre"]="Nombre";
$ArrayArticles["producto.Marca"]= 'Marca';
$ArrayArticles["producto.Modelo"]= 'Modelo';
$ArrayArticles["movimientop.Existencia"]="Stock" ;
$ArrayArticles["proveedor.Nombres"]= "Proveedor";
$ArrayArticles["proveedor.Telefono"]= utf8_encode('Teléfono');
$ArrayArticles["detallemov.Costo"]= "Costo";
$ArrayArticles["movimientop.charge"]= "Nose";
$ArrayArticles["detallemov.Cantidad"]= "Cantidad";
$ArrayArticles["detallemov.CodigoD"]= "Detalle";
$ArrayArticles["movimientop.StopMinimo"]= "MIN";
$ArrayArticles["movimientop.StopMax"]= utf8_encode('MAX');
$ArrayArticles["proveedor.CodigoProve"]= "CodigoProve";
$ArrayArticles["movimientop.CostoD"]= "Precio";
$ArrayArticles["detallemov.Fecha"]= "Fecha";
$ArrayArticles["detallemov.CodigoAux"]= "CodigoAux";
$ArrayArticles["movimientop.CostoM"]= "PrecioM";
$ArrayArticles["movimientop.CantidadM"]= "PorMayor";
$ArrayArticles["movimientop.iva"] = "IVA";
$ArrayArticles["movimientop.ILA"] = "ILA";
$ArrayArticles["producto.Descripcion"] = utf8_encode('Descripción');
if (isset($ArrayArticles[$Clave])){
return $ArrayArticles[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){



return  null;

} 

}
