<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ReporWarehouseModels extends CI_Model
{
    /*
    `SELECT  tienda.NombreT AS Tienda, clasificacion.Nombre AS Area,producto.CodigoP AS Codigo, producto.Nombre AS Producto ,producto.Marca AS Marca, producto.Modelo AS Modelo,movimientop.Existencia AS Stock, proveedor.Nombres AS Proveedor, proveedor.Telefono AS Telefono,  movimientop.charge as Encargo,  detallemov.Costo As Costo, detallemov.Cantidad As Ultima_Compra, detallemov.CodigoD AS Detalle,  movimientop.StopMinimo AS Minimo, movimientop.StopMax AS Max FROM tienda 
    LEFT JOIN movimientop ON movimientop.CodigoT = tienda.Codigo
    LEFT JOIN producto ON movimientop.CodigoP = producto.CodigoP 
    LEFT JOIN clasificacion On clasificacion.ID = producto.Clasificacion 
    LEFT JOIN detallemov ON movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )
    LEFT JOIN proveedor ON detallemov.CodigoProve  = proveedor.CodigoProve  
    WHERE  ( producto.Status = 'Activo' )  ORDER BY movimientop.Existencia ASC`
    */
    private $Tabla = "tienda";
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposTablas = ["movimientop.CodigoM","producto.CodigoP","clasificacion.Nombre","tienda.NombreT","producto.Nombre","producto.Marca","producto.Modelo","movimientop.Existencia","proveedor.Nombres","proveedor.Telefono","movimientop.charge", "detallemov.Costo", "detallemov.Cantidad", "detallemov.CodigoD", "movimientop.StopMinimo", "movimientop.StopMax","tienda.Codigo","producto.Unidades","proveedor.CodigoProve","movimientop.CostoD","detallemov.Fecha","detallemov.CodigoAux", "movimientop.iva","producto.Descripcion","movimientop.ILA"];
    private function InitJoin(){
        $this->db->join("movimientop"," movimientop.CodigoT = tienda.Codigo","LEFT",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("clasificacion","clasificacion.ID = producto.Clasificacion","LEFT",false);
        $this->db->join("detallemov","movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM AND detallemov.Status =  'Entrada' )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )","LEFT",false);
        $this->db->join("proveedor","detallemov.CodigoProve  = proveedor.CodigoProve","LEFT",false);
        $this->db->where('producto.Status',$this->db->escape("Activo"),false);
        $this->db->where('movimientop.Status',$this->db->escape("Activo"),false);
       }
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }
    private function ValidarCdProducto2($CD){
        
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
    
        if (count($Res) ===0){
            return false;
        }
       
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
      
        return TRUE;

    }



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
      
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        $poli = false;
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
               
              $arr1[$i] =  $Array2;
            }else {
                if ( $poli == false){

               
              $auxCodigo =  $this->ValidarCdProducto2($arr1[$i]);
              
              if ( $auxCodigo != false ){
               
                $auxCodigo = $auxCodigo === TRUE ?  $arr1[$i] :$auxCodigo;
               
                $poli = true;
                $arr1[$i]= array("producto.CodigoP", $this->db->escape($auxCodigo));
              }else{
                $arr1[$i]= array("Todo", $arr1[$i]);
              }
                
            }else{
                $arr1[$i]= array("Todo", $arr1[$i]);
                // unset($arr1[$i]);
            //$arr1  = array_splice( $arr1,$i);
              //  $arr1[$i] = null;
            }
        }
        }
    
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getReporWarehouse($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->distinct()->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where($this->Tabla.'.CodigoM',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getReporWarehouseLimite($Canti,$Desde){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporWarehouseLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporWarehouseLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporWarehouseIdColum($id,$Columnas){
       
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReporWarehouseLimiteColum($Canti,$Desde,$Columnas){
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporWarehouseFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
      
        $this->db->distinct()->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->distinct()->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReporWarehouseFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas(),false);
     return   $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporWarehouseFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporWarehouseFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->distinct()->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporWarehouseFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getReporWarehouseFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave= null){
$ArrayReporWarehouse["movimientop.CodigoM"]= utf8_encode("Código");
$ArrayReporWarehouse["producto.Unidades"]= "Unidades";
$ArrayReporWarehouse["tienda.NombreT"]= "Tienda";
$ArrayReporWarehouse["tienda.Codigo"]= "CodTienda";
$ArrayReporWarehouse["clasificacion.Nombre"]=  utf8_encode('Área');
$ArrayReporWarehouse["producto.CodigoP"]= utf8_encode("Producto");
$ArrayReporWarehouse["producto.Nombre"]="Nombre";
$ArrayReporWarehouse["producto.Marca"]= 'Marca';
$ArrayReporWarehouse["producto.Modelo"]= 'Modelo';
$ArrayReporWarehouse["movimientop.Existencia"]="Stock" ;
$ArrayReporWarehouse["proveedor.Nombres"]= "Proveedor";
$ArrayReporWarehouse["proveedor.Telefono"]= utf8_encode('Teléfono');
$ArrayReporWarehouse["detallemov.Costo"]= "Costo";
$ArrayReporWarehouse["movimientop.charge"]= "Nose";
$ArrayReporWarehouse["detallemov.Cantidad"]= "Cantidad";
$ArrayReporWarehouse["detallemov.CodigoD"]= "Detalle";
$ArrayReporWarehouse["movimientop.StopMinimo"]= "MIN";
$ArrayReporWarehouse["movimientop.StopMax"]= utf8_encode('MAX');
$ArrayReporWarehouse["proveedor.CodigoProve"]= "CodigoProve";
$ArrayReporWarehouse["movimientop.CostoD"]= "Precio";
$ArrayReporWarehouse["detallemov.Fecha"]= "Fecha";
$ArrayReporWarehouse["detallemov.CodigoAux"]= "CodigoAux";
$ArrayReporWarehouse["movimientop.iva"]= "IVA";
$ArrayReporWarehouse["producto.Descripcion"] = utf8_encode('Descripción');
$ArrayReporWarehouse["movimientop.ILA"] = "ILA";
if($Clave === null){
    $array = array();
    foreach($ArrayReporWarehouse as $key => $val) {
        $array[$val]= array_search(array_search($val,$ArrayReporWarehouse),$this->CamposTablas)
       ;
    }
    
   
    return $array;
}       


if (isset($ArrayReporWarehouse[$Clave])){
return $ArrayReporWarehouse[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){

    $meta3['Producto'] = [
        "name"=> 'Producto',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Product',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s02',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Área'] = [
        "name"=> 'Área',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Classification',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Clasificación',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Rut'] = [
        "name"=> 'Rut',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s11',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Tienda'] = [
        "name"=> 'Tienda',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Store',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Tienda',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Apellidos'] = [
        "name"=> 'Apellido',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s33',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Armador'] = [
        "name"=> 'Nombre',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s22',
        "necessary"=> true, 
        "modified"=> false,  
    ];

    $meta3['Region'] = [
        "name"=> 'Región',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>"",
        "1"=>"Región de Arica y Parinacota",
        "2"=>"Región de Tarapacá",
        "3"=>"Región de Antofagasta",
        "4"=>"Región de Atacama",
        "5"=>"Región de Coquimbo", 
        "6"=>"Región de Valparaíso",
        "7"=>"Región del Libertador General Bernardo O'Higgins",
        "8"=>"Región del Maule",
        "9"=>"Región del Biobío",
        "10"=>"Región de La Araucanía",
        "11"=>"Región de Los Ríos",
        "12"=>"Región de Los Lagos",
        "13"=>"Región Aysén del General Carlos Ibáñez del Campo",
        "14"=>"Región de Magallanes y de la Antártica Chilena",
        "27"=>"Región de Ñuble",
        ],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Comuna'] = [
        "name"=> 'Comuna',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Ciudad'] = [
        "name"=> 'Ciudad',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];

 
   $T =  $this->total();
    $obj = new stdClass();
    $obj->Total  = $T[0]->Total;
    $obj->Campos= $this->Mascara();
    $obj->Select= $meta3;
return $obj;

} 

}
