<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class WarehouseModels extends CI_Model
{
    private $Tabla = "detallemov";
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposInternos = ['CodigoD'=>'CodigoMo', 'CodigoMo'=>'CodigoM','CodigoU'=>'CodigoU','Fecha'=>'Fecha', "Status"=>"Status","CodigoProve"=>"CodigoProve","Hora"=>"Hora","CantidadActual"=>"CantidadActual","ExistenciaAntes","ExistenciaAntes", "CodigoAux"=>"CodigoAux"];
    private $Select =null;
    private $SoloLetras = [];
    private $CamposNecesarios = ['CodigoMo'=>'CodigoMo', 'Cantidad'=>'Cantidad'];
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }

    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="CodigoP")
              {
                $Array2[1]= $this->ValidarCdProducto($Array2[1]);
              }
               
              $arr1[$i] =  $Array2;
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->db->list_fields($this->Tabla);
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getWarehouse($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->select($this->Columnas());
        return  $this->db->get($this->Tabla)->result();
       }else{
           $Columna = $this->columna(0);
           $this->db->select($this->Columnas());
        return  $this->db->get_where($this->Tabla,array("$Columna"=>$id))->result();
       }
       
    }
    public function getWarehouseLimite($Canti,$Desde){
        $this->db->select($this->Columnas());
        
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getWarehouseLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->select($this->Columnas());
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getWarehouseLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas($Columnas,true));
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getWarehouseIdColum($id,$Columnas){
  
        $this->db->select($this->Columnas($Columnas,true));
        $Columna = $this->columna(0);
        return  $this->db->get_where($this->Tabla,array("$Columna"=>$id))->result();
    }
    public function getWarehouseLimiteColum($Canti,$Desde,$Columnas){
        $this->db->select($this->Columnas($Columnas,true));
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getWarehouseFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;  
      $arrayconsulta=  $this->Filtros($Filtro); 
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
      
        $this->db->select($this->Columnas());
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total($Tabla = null){
        $this->db->select("count(*) As Total");
        if($Tabla=== null){
            return  $this->db->get($this->Tabla)->result();
        }else{
            return  $this->db->get($Tabla)->result();
        }
        
    }
    public function getWarehouseFiltroLimite($Filtros,$Canti,$Desde){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
      
        $this->db->select($this->Columnas());
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getWarehouseFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro); 
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas());
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getWarehouseFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro); 
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->select($this->Columnas($Columnas,true));
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getWarehouseFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true));

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getWarehouseFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro); 
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1]);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->db->list_fields($this->Tabla);
            $poli=false;
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1] );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1]);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('."Status",$arrayconsulta[$i][1] );
               }
            }
            $this->db->or_where('Status <>',"'Activo')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true));

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave){
$ArrayWarehouse["CodigoD"]=  utf8_encode('Código');
$ArrayWarehouse["CodigoMo"]=  utf8_encode('Asignacion');
$ArrayWarehouse["CodigoU"]= utf8_encode("Usuario");
$ArrayWarehouse["Vencimiento"]="Vence";
$ArrayWarehouse["CodigoProve"]= 'Proveedor';
$ArrayWarehouse["Costo"]="Costo" ;
$ArrayWarehouse["Observacion"]= utf8_encode("Observación");
$ArrayWarehouse["ExistenciaAntes"]= "Antes";
$ArrayWarehouse["CantidadActual"]= "Actual";
$ArrayWarehouse["CodigoAux"]= "Producto";
if (isset($ArrayWarehouse[$Clave])){
return $ArrayWarehouse[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }
private function validar($Datos){
    $meta = $this->MetaData(false);
    $ArrayDatos = array();
    while (current($Datos)!==false) {
        $verificar = current($Datos);
        if(is_numeric(key($Datos))===false){
            $clave=  $this->verificarExistencia(key($Datos),$meta);
            if ($clave=== false){
                
                $clave = "Error";
            }
        }else{
            $clave = intval(key($Datos));
        }
        
        if (!isset($meta[$clave])){
         //   end($Datos);
           // return false;
        }else{
        if (intval($meta[$clave]["len"]) < strlen($verificar) && $meta[$clave]["len"]!= null ){
            end($Datos);
            return false;
        } 

        }
        if($clave != "Error"){
            $ArrayDatos[$meta[$clave]["nombre"]] = $verificar;
        }
        

          next($Datos);
          }
          return $ArrayDatos;     
}
private function CDproducto1($Cant,$N){
    $Cant2=strval($Cant);
    $Num = $N-strlen($Cant);
    $Cd="";
    for($i = 0; $i < $Num;$i++){
    $Cd=$Cd."0";
    }
    $Cd=$Cd.$Cant;
    return $Cd;
    }

    public function generarCodigo(){
        $Codigo = "";
    
        $Cant= $this->total("producto");
        $Cant=  $Cant[0]->Total;
        $Codigo =$Cant+1;
        $Codigo=$this->CDproducto1($Codigo,5);
        $Cant2=$this->total("movimientop");
        $Cant2=  $Cant2[0]->Total;
        $Cant2=$Cant2+1;
        $Cant3=$this->total("detallemov");
        $Cant3=  $Cant3[0]->Total;
        $Codigo=$this->CDproducto1( $Cant3,5).$this->CDproducto1($Cant2,5).$Codigo;
          return $Codigo;
        }   
private function VerificarDetalle($CodigoMo,$Fecha ="0000-00-00"){
  $Fecha2 = $Fecha===""? "0000-00-00": $Fecha;
  $Fecha2 = $Fecha === null ? "0000-00-00":$Fecha;
  $Fecha2 = $Fecha === 'null' ? "0000-00-00":$Fecha;

     $this->db->select(["CantidadActual","CodigoAux","CodigoD"]);
 $Datos= $this->db->get_where("detallemov",array("Vencimiento"=>$Fecha2,"CodigoMo"=>$CodigoMo,"CantidadActual > "=>0, "Status"=>"Entrada"))->result();

 if(count($Datos)===0){
     $Codigo = $this->generarCodigo();
    
    $this->CrearProducto($CodigoMo,$Codigo);
     return array("Codigo"=>$Codigo,"Cantidad"=>0);
 }else{
    $where = "CodigoD = '". $Datos[0]->CodigoD."' ";
   
    $this->db->update("detallemov",array("CantidadActual"=>0 ), $where );
    if($Datos[0]->CodigoAux === ""){
        $Codigo = $this->generarCodigo();
        $this->CrearProducto($CodigoMo,$Codigo);
        $Datos[0]->CodigoAux=  $Codigo;
    } 
    return array("Codigo"=> $Datos[0]->CodigoAux,"Cantidad"=>$Datos[0]->CantidadActual);
 } 
}
private function CrearProducto($Ref,$Codigo){
   
    $this->db->select(["CodigoP","CodigoT"]);
    $Datos= $this->db->get_where("movimientop",array("CodigoM"=>$Ref))->result();
    
    return $this->db->insert("producto",array("CodigoP"=>$Codigo,"Status"=>"Auxiliar","CodigoAux"=>$Datos[0]->CodigoP));

}
private function VerificarMovimiento($Tienda,$Producto){
    $Producto = $this->ValidarCdProducto($Producto);
    $this->db->select(["CodigoM","CostoD","","CostoM","CantidadM","iva","StopMinimo","StopMax"]);
    $DatosMovi =$this->db->get_where("movimientop",array("CodigoT"=>$Tienda,"CodigoP"=>$Producto,"Status"=>"Activo"))->result();
     if (count($DatosMovi) ===0){
        $this->db->select(["CodigoM","CostoD","","CostoM","CantidadM","iva","StopMinimo","StopMax"]);
        $DatosMovi =$this->db->get_where("movimientop",array("CodigoP"=>$Producto,"Status"=>"Activo"))->result();
      
        $this->db->insert("movimientop",array("CostoD"=>$DatosMovi[0]->CostoD,"CostoM"=>$DatosMovi[0]->CostoM,"CantidadM"=>$DatosMovi[0]->CantidadM,"iva"=>$DatosMovi[0]->iva,"StopMinimo"=>$DatosMovi[0]->StopMinimo,"StopMax"=>$DatosMovi[0]->StopMax,"CodigoT"=>$Tienda,"CodigoP"=>$Producto ));
        return $this->db->insert_id();
     }else{
         return $DatosMovi[0]->CodigoM;
     }
     }
public function Add($datos){
   // validamos los datos
    $ArrayDatos= $this->validar($datos);
    if( $ArrayDatos === false){
        return array("Error"=>"Verificar Datos");
    }

    // verificamos campos necesarios en la base de datos
    foreach ($this->CamposNecesarios as $campo){
        if (!isset($ArrayDatos[$campo])){
            return array("Error"=>"Debe Enviar Campo $campo");
        }
     }
    
     if(isset($datos["Tienda"])){
       
        $ArrayDatos["CodigoMo"] = $this->VerificarMovimiento($datos["Tienda"],$datos["Producto"] );
        $datos["CodigoMo"] =  $ArrayDatos["CodigoMo"];
     }
  
 
     // verificamos si existe otro detalle con el mismo CD movi y fecha de vencimiento
     // de ser asi se toma el codigo 
     $ArrayDatos["Status"] = $ArrayDatos["Status"] === 0 ? "Entrada":"Salida";
  
     $Datos= $this->VerificarDetalle($datos["CodigoMo"],$datos["Vencimiento"]);
     $Token = obtnerToken();
     $Autho = "";
     if($Token != FALSE){
     $Autho =str_replace('Bearer ','', $Token);
     }
     if( $Autho !=""){
     $Autho =str_replace('Bearer ','', $Autho);
     $Token = ValidarToken($Autho);
     }
     if ( $Token === FALSE ){
        $DatosGET= isset($_GET["x"]) ? $_GET["x"]: "" ;
      
       
        $DatosGET =  $DatosGET!=""?ValidarToken($DatosGET) :"";
        $Token  =$DatosGET!=''?$DatosGET: $Token ;
        
       }
       if ( $Token === FALSE ){
        $DatosGET= isset($_GET["x"]) ? $_GET["x"]: "" ;
      
       
        $DatosGET =  $DatosGET!=""?ValidarToken($DatosGET) :"";
        $Token  =$DatosGET!=''?$DatosGET: $Token ;
        
       }
     if(isset($this->session)){
        $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
  }else{
        $ID =   $Token== FALSE ? null :  $Token ;
  }
    $ArrayDatos["CodigoU"] = $ID;
    $ArrayDatos["Fecha"] =  date("Y-m-d");
    $ArrayDatos["Hora"] =   date("H:i:s");
    
  
    $this->db->select(["CodigoM","CostoD","Existencia","CostoM","CodigoP"]);
   $DatosMovi =$this->db->get_where("movimientop",array("CodigoM"=> $ArrayDatos["CodigoMo"]))->result();
   $ArrayDatos["ExistenciaAntes"] = $DatosMovi[0]->Existencia;
   if( $DatosMovi[0]->Existencia < 0){
    $ArrayDatos["CantidadActual"] = $ArrayDatos["Cantidad"] + $Datos["Cantidad"] + $DatosMovi[0]->Existencia ;
   }else{
    $ArrayDatos["CantidadActual"] = $ArrayDatos["Cantidad"] + $Datos["Cantidad"];
   }


   //aqui vamos a modificar la existencia total 
     $where = "CodigoM = '".$ArrayDatos["CodigoMo"]."' ";
     $Exis = $DatosMovi[0]->Existencia + $ArrayDatos["Cantidad"];
     if($datos["Precio"]!= ""){
        $Mayor= $datos["Precio"];
      if($DatosMovi[0]->CostoM > 0){
        $Mayor=  ($DatosMovi[0]->CostoM * $datos["Precio"])/$DatosMovi[0]->CostoD;
       
      }  
      $this->db->update("movimientop",array("Existencia"=>$Exis,"CostoD"=>$datos["Precio"], "CostoM"=>$Mayor ), $where );
     }else{
        
        $this->db->update("movimientop",array("Existencia"=>$Exis ), $where );
    }    
  if($Datos["Codigo"] == null){
    $Datos["Codigo"] = $this->generarCodigo();
  }
 
    $ArrayDatos["CodigoAux"] = $Datos["Codigo"];
    
    $this->db->insert($this->Tabla, $ArrayDatos);
    $ultimoId = $this->db->insert_id();
    $Nom = null;
    $tele = null;
    if($ArrayDatos["CodigoProve"] != null){
        $this->db->select(["Nombres","Telefono"]);
        $DatosProv =$this->db->get_where("proveedor",array("CodigoProve"=> $ArrayDatos["CodigoProve"]))->result();
        $Nom=$DatosProv[0]->Nombres;
        $tele=$DatosProv[0]->Telefono;
    }
    
    $Respuesta = array("Costo"=>$ArrayDatos["Costo"],"Cantidad"=>$ArrayDatos["Cantidad"],"Detalle"=>$ultimoId,"CodigoProve"=>$ArrayDatos["CodigoProve"],"Proveedor"=>$Nom,utf8_encode('Teléfono')=>$tele ,"CodigoAux"=>$Datos["Codigo"],"Fecha"=>$ArrayDatos["Fecha"],"Stock"=> $Exis,"Precio"=>$datos["Precio"]);
    // Aqui modificamos el woorpres
    $WOOR= $this->ConfigModels->Value("WOOR");
    $MiTienda= $this->ConfigModels->Value("MiTienda");
    worpress($WOOR,$ArrayDatos["CodigoMo"], $MiTienda);
    return  $Respuesta;
  
   
   }

 private function BuscarDetealle($id=null,$Aux = null,$Mov = null,$Fecha = null){
    if($id != null){
        $this->db->select(["CantidadActual","CodigoAux","CodigoD","CodigoMo"]);
        $this->db->where('CantidadActual >',0);
        $this->db->where('CodigoD',$id);
        $Datosdeta =$this->db->get("detallemov",1)->result();
        return  $Datosdeta;

     }
     if($Aux != null){
        $this->db->select(["CantidadActual","CodigoAux","CodigoD","CodigoMo"]);
        $this->db->where('CantidadActual >',0);
        $this->db->where('CodigoAux',$Aux);
        $Datosdeta =$this->db->get("detallemov",1)->result();
        return  $Datosdeta;

     }
     if($Fecha === null){
        $this->db->select(["CantidadActual","CodigoAux","CodigoD","CodigoMo"]);
        $this->db->where('CantidadActual >',0);
        $this->db->where('CodigoMo',$Mov);
        $this->db->order_by("Vencimiento","ASC");
        $Datosdeta =$this->db->get("detallemov",1)->result();
        return  $Datosdeta;
     }else{
        $this->db->select(["CantidadActual","CodigoAux","CodigoD","CodigoMo"]);
        $this->db->where('CantidadActual >',0);
        $this->db->where('CodigoMo',$Mov);
        $this->db->where('Vencimiento',$Fecha);
        $this->db->order_by("Vencimiento","ASC");
        $Datosdeta =$this->db->get("detallemov",1)->result();
        return  $Datosdeta; 
     }
     $Arrayres = [];
     return  $Arrayres;

 }

 private function EliminarRecursivo($Cantidad,$Mov){
     if($Cantidad === 0){ 
         return 0 ;
     }
    
    $Datosdeta = $this->BuscarDetealle(null,null,$Mov);
    if( count($Datosdeta) ===0){
        return 0;
    }
    $Actual =  $Datosdeta[0]->CantidadActual -$Cantidad;
    if($Actual <= 0 ){
      $where = "CodigoD = '".$Datosdeta[0]->CodigoD."' ";
      $this->db->update("detallemov",array("CantidadActual"=>0, "CodigoAux"=> NULL ), $where );
      if( $Datosdeta[0]->CodigoAux != NULL AND $Datosdeta[0]->CodigoAux != "" ){
        $where = "CodigoP = '".$Datosdeta[0]->CodigoAux."' ";
        $this->db->delete("producto",$where,1 );
      }
      $Actual = $Actual* -1;
     return $this->EliminarRecursivo($Actual,$Mov);
    }else{
        $where = "CodigoD = '".$Datosdeta[0]->CodigoD."' ";
        $this->db->update("detallemov",array("CantidadActual"=>$Actual ), $where );
        return 0;
    }
   
 }

public function Edit($datos){
     
      $Datosdeta =array();
     
      if(!isset($datos["Cantidad"])){
        return array("Error"=>"Registros");
      }
    
      if(isset($datos["Detalle"])){
        $Datosdeta = $this->BuscarDetealle($datos["Detalle"]);
        
      }else{
              if(isset($datos["CodigoAux"])){
        $Datosdeta = $this->BuscarDetealle(null,$datos["CodigoAux"]);
 
              }else{
        if(isset($datos["CodigoMo"]) AND isset($datos["Vence"])){
            $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"],$datos["Vence"]);
            if(count($Datosdeta)===0 AND isset($datos["CodigoMo"]) ){
                $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"]);
            }
        }else{
            if(isset($datos["CodigoMo"])){
                $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"]);
            }else{
                return array("Error"=>"Registros");
            }
        }
      }
    
       
      }
      if(count($Datosdeta)==0){
        if(isset($datos["CodigoMo"]) AND isset($datos["Vence"])){
            $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"],$datos["Vence"]);
            if(count($Datosdeta)===0 AND isset($datos["CodigoMo"]) ){
                $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"]);
            }
        }else{
            if(isset($datos["CodigoMo"])){
                $Datosdeta = $this->BuscarDetealle(null,null,$datos["CodigoMo"]);
            }else{
                return array("Error"=>"Registros");
            }
        }
      }

      $Mov = count($Datosdeta) ===0 ? $datos["CodigoMo"] : $Datosdeta[0]->CodigoMo;
      $obs =  isset($datos["Observacion"]) ? $datos["Observacion"] : "";
 $Actual =0;
       if(count($Datosdeta) === 1){
        $Actual =  $Datosdeta[0]->CantidadActual -$datos["Cantidad"];
        
        if($Actual < 0){ 

            $Actual=  $this->EliminarRecursivo($datos["Cantidad"],$Mov);
            // aqui tenemos que analizar lo que vamos a hacer es verificar si existe otro 
           // return array("Error"=>"Cantidad no disponible");
        }
        if($Actual === 0){
            // si es igual a 0 debemos eliminar el codigo aux  para evitar una relacion a un codigo 
            // que hace referencia a un lote que no tiene producto

            $where = "CodigoD = '".$Datosdeta[0]->CodigoD."' ";
            $this->db->update("detallemov",array("CantidadActual"=>$Actual, "CodigoAux"=> NULL ), $where );
            if( $Datosdeta[0]->CodigoAux != NULL AND $Datosdeta[0]->CodigoAux != "" ){
                // luego buscamos el producto con ese codigo aux y lo eliminamos por que no sera usado mas
                $where = "CodigoP = '".$Datosdeta[0]->CodigoAux."' ";
                $this->db->delete("producto",$where,1 );
              }
        }else{
            // de ser distinto de cero lo que hacemos es actualizar a la cantidad actual
            $where = "CodigoD = '".$Datosdeta[0]->CodigoD."' ";
            $this->db->update("detallemov",array("CantidadActual"=>$Actual ), $where );
         
        }
       
       
       }
       if ($Mov != null and $Mov != ""){
       $Detalle = count($Datosdeta) ===0 ? NULL : $Datosdeta[0]->CodigoD;
        $Respuesta = array("Cantidad"=>$Actual,"Detalle"=>$Detalle);
        $Token = obtnerToken();
        $Autho = "";
        if($Token != FALSE){
        $Autho =str_replace('Bearer ','', $Token);
        }
        if( $Autho !=""){
        $Autho =str_replace('Bearer ','', $Autho);
        $Token = ValidarToken($Autho);
        }
        if ( $Token === FALSE ){
            $DatosGET= isset($_GET["x"]) ? $_GET["x"]: "" ;
          
           
            $DatosGET =  $DatosGET!=""?ValidarToken($DatosGET) :"";
            $Token  =$DatosGET!=''?$DatosGET: $Token ;
            
           }
        if(isset($this->session)){
            $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
      }else{
            $ID =   $Token== FALSE ? null :  $Token ;
      }
        $Usuario = $ID;
           if($obs != ""){
            $this->db->insert("detallemov",array("CodigoMo"=>$Mov,"Fecha"=> date("Y-m-d"),"Cantidad"=>$datos["Cantidad"], "CodigoU"=> $Usuario, "Status"=>"Salida", "Observacion"=> $obs));
           }
        $this->db->select(["Existencia"]);
        $DatosMov =$this->db->get_where("movimientop",array("CodigoM"=> $Mov))->result();
        $where = "CodigoM = '".$Mov."' ";
        $ActualMov = $DatosMov[0]->Existencia -$datos["Cantidad"];
        $this->db->update("movimientop",array("Existencia"=>$ActualMov ), $where );
        // aqui actualizamos el woorpress
       $WOOR= $this->ConfigModels->Value("WOOR");
       $MiTienda= $this->ConfigModels->Value("MiTienda");
        worpress($WOOR,$Mov,$MiTienda);
        return  $Respuesta;
       }
       return array("Error"=>"Registros");
    
  }
public function Delete($ID){

   
    return array("Error"=>"Registros no se eliminan");
  
}

private function FormatoRut($Rut){
    $newRut = str_replace(".", "", $Rut);
    $newRut = str_replace("-", "", $newRut);
    $Ultimo = substr($newRut, -1);
    $rest = substr($newRut, 0, -1);
   
    return $rest."-".$Ultimo;
   }
   Public function MetaData($Mascara = true){
      
    $meta = $this->db->field_data($this->Tabla);

    $meta2 =array();
    $meta3 = array();
    $i=0;
    foreach ($meta as $field)
{ 
if($Mascara=== true){
   
   if(!isset($this->CamposInternos[$field->name]) && !isset($this->Select[$field->name]) ){
    $id= (string)$i;
    $meta2[$id] = [
        "name"=> $this->Mascara($field->name),
        "value"=> $field->name === "iva"? "19" : "" ,
        "Tipo"=>  $field->type === "longtext" || $field->type === "varchar" || $field->type === "date" ? "a":"n",       
        "disabled"=> false, 
        "len"=> $field->type === "date"? 10 :$field->max_length,         
        "primary"=>$field->name =="CodigoP",  
        "type"=> $field->type === "date"? $field->type : "text",    
        "necessary"=> isset($this->CamposNecesarios[$field->name]), 
        "modified"=> false,  
        "Buscar" => $field->name =="CodigoP",
    ];
    
    if(isset($this->SoloLetras[$field->name])){
        $meta2[$id]["Tipo"] = $this->SoloLetras[$field->name];
    }
   }
   if (isset($this->Select[$field->name])){
    $id= (string)$i;
    $meta3[$id] = [
        "name"=> $this->Mascara($field->name),
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>$field->name =="CodigoP",
        "date"=>$this->Select[$field->name]["date"],
        "option"=>$this->Select[$field->name]["option"],
        "filter"=>$this->Select[$field->name]["filter"],
        "Datos"=>$this->Select[$field->name]["Datos"],
        "necessary"=> $this->Select[$field->name]["necessary"], 
        "modified"=> false,  
    ];
   
   } 
   $Total = $this->total();
   $meta2["Total"] = $Total[0]->Total;
   $meta2["Select"]= null;
   $meta2["Delimitador"] = $this->Delimitador;
   $meta2["Separador"]  = $this->Separador;
   $Token = FALSE;
   $Token = obtnerToken();
   $Autho = "";
   if($Token != FALSE){
   $Autho =str_replace('Bearer ','', $Token);
   }
   if( $Autho !=""){
   $Autho =str_replace('Bearer ','', $Autho);
   $Token = ValidarToken($Autho);
   }
   if ( $Token === FALSE ){
    $DatosGET= isset($_GET["x"]) ? $_GET["x"]: "" ;
  
   
    $DatosGET =  $DatosGET!=""?ValidarToken($DatosGET) :"";
    $Token  =$DatosGET!=''?$DatosGET: $Token ;
    
   }
   if(isset($this->session)){
    $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
}else{
    $ID =   $Token== FALSE ? null :  $Token ;
}
   $User = $this->UserModels->getUser($ID);
   $Nivel =$User[0]->Nivel;
   $Permiso= $this->db->get_where('detalleniveles',array("Status"=>"Activo","Ruta"=>"Warehouse","Nivel"=>$Nivel))->result();
        if(  count($Permiso)>0){
            $meta2["Permiso"] = $Permiso[0]->Permiso;
        }else{
            $meta2["Permiso"] = 6;
        }
   
}else{
    $meta2[$i] = ["nombre"=> $field->name, "len"=> $field->max_length, "type"=> $field->type, "Obligatorio"=>isset($this->CamposNecesarios[$field->name]),"ID"=>$i];
   
}

$i++;
}

   return   $meta2;
} 

}